% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suffix.R
\name{host_extract}
\alias{host_extract}
\title{Extract hosts}
\usage{
host_extract(domains)
}
\arguments{
\item{domains}{a vector of domains, retrieved through \code{\link{url_parse}} or
\code{\link{domain}}.}
}
\value{
a data.frame of two columns: \code{domain}, with the original domain names,
and \code{host}, the identified host from the domain.
}
\description{
\code{host_extract} extracts the host from
a vector of domain names. A host isn't the same as a domain - it could be
the subdomain, if there are one or more subdomains. The host of \code{en.wikipedia.org}
is \code{en}, while the host of \code{wikipedia.org} is \code{wikipedia}.
}
\examples{
# With subdomains
has_subdomain <- domain("https://en.wikipedia.org/wiki/Main_Page")
host_extract(has_subdomain)

# Without
no_subdomain <- domain("https://ironholds.org/projects/r_shiny/")
host_extract(no_subdomain)
}

