% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitly_groups.R
\name{bitly_update_group}
\alias{bitly_update_group}
\title{Update a Group}
\usage{
bitly_update_group(
  group_id = NA,
  name = NA,
  organization_id = NA,
  showRequestURL = F
)
}
\arguments{
\item{group_id}{- a required string | A GUID for a Bitly group}

\item{name}{- username to change}

\item{organization_id}{- an optional string parameter | A GUID for a Bitly organization}

\item{showRequestURL}{- an optional T/F value to whether show URL which has been
build and requested from server. For debug purposes, default FALSE.}
}
\description{
Update the details of a group
}
\section{Group}{

Groups are a subdivision within an organization. A user will belong to a group within an organization.
Most actions on our API will be on behalf of a group. For example, when you
shorten a link, it will be on behalf of a user and a group.
}

\examples{
\dontrun{
ui <- bitly_user_info(showRequestURL = TRUE)
up_group <- bitly_update_group(group_id = ui$default_group_guid[1], name = "New Group Name", 
organization_id = "asd")
}
}
\seealso{
\url{https://dev.bitly.com/v4/#operation/updateGroup}

[bitly_update_user()]
}
