% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ApiKey.R
\name{googl_auth}
\alias{bitly_auth}
\alias{googl_auth}
\title{Assign API tokens using OAUTH2}
\usage{
googl_auth(key = "", secret = "")

bitly_auth(key = "", secret = "")
}
\arguments{
\item{key}{- Client ID}

\item{secret}{- Client Secret}
}
\description{
You must register an application in order to get Client ID and Client Secret code. 
For Bit.ly, go to \url{https://bitly.com/a/oauth_apps} and in the field \code{Redirect URIs:} 
type for example "http://localhost:1410". 
For Goo.gl API Keys you must go to the \url{https://console.developers.google.com/project}, 
select "APIs & auth", then "Credentials", then "add OAUTH2 client ID" and lastly you select 
"Type:Other".
}
\examples{
\dontrun{
googl_token <-
  googl_auth(key = "806673580943-78jdskus76fu7r0m21erihqtltcka29i.apps.googleusercontent.com",
             secret = "qItL-PZnm8GFxUOYM0zPVr_t")
bitly_token <-
  bitly_auth(key = "be03aead58f23bc1aee6e1d7b7a1d99d62f0ede8",
             secret = "b7e4abaf8b26ec4daa92b1e64502736f5cd78899")
}

}
\seealso{
See \url{http://dev.bitly.com/rate_limiting.html}

See \url{http://dev.bitly.com/authentication.html}

See \url{https://developers.google.com/url-shortener/v1/getting_started#APIKey}
}

