% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{uni_em}
\alias{uni_em}
\title{EM algorithm to fit weighted ash objective.}
\usage{
uni_em(weight_vec, lmat, pi_init, lambda, itermax, obj_tol)
}
\arguments{
\item{weight_vec}{A vector of weights. Each element of \code{weight_vec} corresponds
to a column of \code{lmat}.}

\item{lmat}{A matrix of inner weights. The columns are the "individuals" and the rows are the "classes."}

\item{pi_init}{The initial values of \code{pivec}. Each element of \code{pi_init}
corresponds to a row of \code{lmat}.}

\item{lambda}{The penalty on the pi's. Should be greater than 0 and really really small.}

\item{itermax}{The maximum number of EM iterations to take.}

\item{obj_tol}{The objective stopping criterion.}
}
\value{
A vector of numerics. The update of \code{pivec} in
    \code{\link{flexdog_full}}.
}
\description{
Solves the following optimization problem
\deqn{\max_{\pi} \sum_k w_k \log(\sum_j \pi_j \ell_jk).}
It does this using a weighted EM algorithm.
}
\author{
David Gerard
}
\keyword{internal}
