% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ashdog.R
\name{flex_update_pivec}
\alias{flex_update_pivec}
\title{Update the distribution of genotypes from various models.}
\usage{
flex_update_pivec(weight_vec, model = c("hw", "bb", "norm", "ash", "f1", "s1",
  "f1pp", "s1pp", "flex", "uniform"), control)
}
\arguments{
\item{weight_vec}{\code{colSums(wik_mat)} from \code{\link{flexdog}}.
This is the sum of current posterior probabilities of each individual
having genotype k.}

\item{model}{What model are we assuming? See the description in \code{\link{flexdog}} for details.}

\item{control}{A list of anything else needed to be passed.
E.g. if \code{model = "ash"},
then \code{inner_weights} needs to be passed through \code{control}
(see \code{\link{get_inner_weights}} for how to get this matrix).}
}
\value{
A list with the following elements
\describe{
  \item{\code{pivec}}{The estimate of the genotype distribution.}
  \item{\code{par}}{A list of estimated parameters. An empty list if the model does not contain any parameters other than \code{pivec}.}
}
}
\description{
Update the distribution of genotypes from various models.
}
\author{
David Gerard
}
