% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsims.R
\name{nsims}
\alias{nsims}
\alias{nsims.default}
\title{Number of Simulations}
\usage{
nsims(x, ...)

\method{nsims}{default}(x, ...)
}
\arguments{
\item{x}{An object.}

\item{...}{Other arguments passed to methods.}
}
\value{
An integer scalar of the number of simulations.
}
\description{
Gets the number of simulations (iterations * chains)
of an MCMC object.

The default methods returns the product of \code{\link[=nchains]{nchains()}} and \code{\link[=niters]{niters()}}.
}
\examples{
nsims.foobar <- function(x, ...) {
  niters(x, ...) * nchains(x, ...)
}
}
\seealso{
Other MCMC dimensions: 
\code{\link{nchains}()},
\code{\link{niters}()},
\code{\link{npars}()},
\code{\link{nsams}()},
\code{\link{nterms}()}
}
\concept{MCMC dimensions}
