% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlgumbel.R
\name{mlgumbel}
\alias{mlgumbel}
\title{Gumbel distribution maximum likelihood estimation}
\usage{
mlgumbel(x, na.rm = FALSE, ...)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{na.rm}{logical. Should missing values be removed?}

\item{...}{\code{sigma0} is an optional starting value defaulting to \code{1}.
\code{rel.tol} is the relative accuracy requested, defaults to
\code{.Machine$double.eps^0.25}. \code{iterlim} is a positive integer
specifying the maximum number of iterations to be performed before the
program is terminated (defaults to \code{100}).}
}
\value{
\code{mlgumbel} returns an object of \link[base:class]{class} \code{univariateML}.
This is a named numeric vector with maximum likelihood estimates for \code{mu}
and \code{s} and the following attributes:
\item{\code{model}}{The name of the model.}
\item{\code{density}}{The density associated with the estimates.}
\item{\code{logLik}}{The loglikelihood at the maximum.}
\item{\code{support}}{The support of the density.}
\item{\code{n}}{The number of observations.}
\item{\code{call}}{The call as captured my \code{match.call}}
\code{shape} and \code{sigma}.
}
\description{
Uses Newton-Raphson to estimate the parameters of the Gumbel distribution.
}
\details{
For the density function of the Gumbel distribution see
\link[extraDistr:Gumbel]{Gumbel}.
}
\examples{
mlgumbel(precip)
}
\references{
Johnson, N. L., Kotz, S. and Balakrishnan, N. (1995) Continuous Univariate Distributions, Volume 2, Chapter 22. Wiley, New York.
}
\seealso{
\link[extraDistr:Gumbel]{Gumbel} for the Gumbel density.
}
