% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text.R
\name{text_wrap}
\alias{text_wrap}
\alias{word_wrap}
\alias{meta_word_cat}
\alias{meta_word_msg}
\alias{word_cat}
\alias{word_msg}
\alias{word_comment}
\title{Text Wrapping Utilities}
\usage{
text_wrap(x, width)

word_wrap(x, width = getOption("width"), tolerance = 8L, hyphens = TRUE,
  unlist = TRUE, collapse = NULL)

meta_word_cat(..., sep = "\\n", width = getOption("width"),
  tolerance = 8L, file = stdout(), trail.nl = TRUE)

meta_word_msg(..., sep = "\\n", width = getOption("width"),
  tolerance = 8L, trail.nl = TRUE)

word_cat(..., sep = " ", width = getOption("width"), tolerance = 8L,
  file = stdout())

word_msg(...)

word_comment(x, width = getOption("width"), tolerance = 8L,
  hyphens = TRUE, unlist = TRUE, color = crayon::has_color())
}
\arguments{
\item{x}{character vector}

\item{width}{what width to wrap at}

\item{tolerance}{how much earlier than \code{width} we're allowed to wrap}

\item{hyphens}{whether to allow hyphenation}

\item{unlist}{logical(1L) if FALSE each element in \code{x} is returned as
an element of a list, otherwise one character vector is returned}
}
\value{
a list with, for each item in \code{x}, a character vector
  of the item wrapped to length \code{width}

if \code{unlist} is a parameter, then a character vector, or
  if not or if \code{unlist} is FALSE, a list with each element from \code{x}
  corresponding to an element from the list
}
\description{
Functions to break up character vector components to a specified width.
}
\details{
\itemize{
  \item \code{text_wrap} breaks each element to a specified \code{width},
    where \code{width} can contain different values for each value in
    \code{x}
  \item \code{word_wrap} wraps at whitespace, or crudely hyphenates if
    necessary; note that unlike \code{text_wrap} \code{width} must be scalar
  \item \code{word_cat} is like \code{word_wrap}, except it outputs to screen
  \item \code{word_msg} is like \code{word_cat}, except it ouputs to stderr
  \item \code{meta_word_cat} is like \code{word_cat}, except it wraps output
    in formatting to highlight this is not normal output
}

Newlines are replaced by empty strings in the output so that each character
vector in the output represents a line of screen output.
}
\keyword{internal}
