% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item.R
\docType{methods}
\name{$.unitizerItem}
\alias{$.unitizerItem}
\alias{$,unitizerItem-method}
\alias{[[,unitizerItem,ANY-method}
\title{Retrieve Test Contents From Test Item}
\usage{
\S4method{$}{unitizerItem}(x, name)

\S4method{[[}{unitizerItem,ANY}(x, i, j, ..., exact = TRUE)
}
\arguments{
\item{x}{a \code{unitizerItem} object, typically \code{.NEW} or \code{.REF}
at the \code{unitizer} interactive prompt}

\item{name}{a valid test sub-component}

\item{i}{a valid test sub-component as a character string, or a sub-component
index}

\item{j}{missing for compatibility with generic}

\item{...}{missing for compatibility with generic}

\item{exact}{unused, always matches exact}
}
\value{
the test component requested
}
\description{
Intended for use within the \code{unitizer} interactive environment, allows
user to retrieve whatever portions of tests are stored by \code{unitizer}.
}
\details{
Currently the following elements are available:

\itemize{
  \item \code{call} the call that was tested as an unevaluated call,
    but keep in mind that if you intend to evaluate this for a reference
    item the environment may not be the same so you could get different
    results (\code{ls} will provide more details)
  \item \code{value} the value that results from evaluating the test, note
    this is equivalent to using \code{.new} or \code{.ref}; note that the
    value is displayed using \code{\link{desc}} when viewing all of
    \code{.NEW} or \code{.REF}
  \item \code{output} the screen output (i.e. anything produced by cat/print,
    or any visible evaluation output) as a character vector
  \item \code{message} anything that was output to \code{stderr}, mostly
    this is all contained in the conditions as well, though there could be
    other output here, as a character vector
  \item \code{conditions} a \code{\link{conditionList}} containing all
    the conditions produced during test evaluation
  \item \code{aborted} whether the test call issues a restart call to the
    `abort` restart, as `stop` does.
}
}
\examples{
## From the unitizer> prompt:
.NEW <- mock_item()  # .NEW is normally available at unitizer prompt
.NEW$call
.NEW$conditions
.NEW$value              # equivalent to `.new`
}
