% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_text_calls.R
\name{mark}
\alias{mark}
\title{Plot marked (or highlighted) text elements.}
\usage{
mark(
  labels,
  x = 0,
  y = 0.55,
  y_layout = "even",
  col = "black",
  col_bg = Seeblau,
  cex = 2,
  font = 2,
  new_plot = "none"
)
}
\arguments{
\item{labels}{A character vector specifying the text labels 
to be plotted.}

\item{x}{A numeric vector of x-coordinates at which the 
text labels in \code{labels} should be written. 
If the lengths of \code{x} and \code{y} differ, 
the shorter one is recycled. 
Default: \code{x = 0}.}

\item{y}{A numeric vector of y-coordinates at which the 
text labels in \code{labels} should be written. 
If the lengths of \code{x} and \code{y} differ, 
the shorter one is recycled. 
Default: \code{y = .55}.}

\item{y_layout}{A numeric value or vector for the vertical 
spacing of labels in \code{labels}. 
2 special values are 
\code{"even"} (i.e., even distribution of labels across available y-space) and 
\code{"flush"} (i.e., no space between adjacent labels, or \code{y_layout = 0}). 
Default: \code{y_layout = "even"}.}

\item{col}{The color(s) of the text label(s). 
Default: \code{col_lbl = "black"}.}

\item{col_bg}{The color(s) to highlight or fill the rectangle(s) with. 
Default: \code{col_bg = Seeblau}.}

\item{cex}{Numeric character expansion factor(s), 
multiplied by \code{par("cex")} to yield the character size(s). 
Default: \code{cex = 2}.}

\item{font}{The font type(s) to be used. 
Default: \code{font = 2} (i.e., bold).}

\item{new_plot}{Should a new plot be generated?
Set to \code{"blank"} or \code{"slide"} to create a new plot. 
Default: \code{new_plot = "none"} (i.e., add to an existing plot).}
}
\description{
\code{mark} plots 1 or more text strings (provided as a character vector \code{labels}) 
to an (existing or new) plot and places a colored box behind
each label to mark it (i.e., highlight or make it stand out from the background).
}
\details{
The positions of the text elements in \code{labels} can be specified by 
providing their coordinates (as \code{x} and \code{y} arguments) or 
by providing an initial position and an \code{y_layout} (see below). 

Text formatting parameters (like \code{col}, \code{col_bg}, \code{cex}, \code{font})         
are recycled to match \code{length(labels)}. 

\code{mark} uses the base graphics system \code{graphics::}.
}
\examples{
# Basics: 
mark(labels = "This is a test.", new_plot = "blank")  # create a new blank plot
mark(labels = "More testing here...", y = .45, col_bg = pal_pinky[[2]])  # add to plot

# Example: 
# (a) Mark text on an existing plot:
plot(x = 0, y = 0, type = "n", xlim = c(0, 1), ylim = c(0, 1), xlab = "", ylab = "")
mark(x = 0, y = .8, labels = "Mark (on an existing plot)")  # uses existing plot

# (b) Mark text on a new plot:
mark(x = 0, y = .8, labels = "Mark (and create a new plot)", 
     new_plot = "slide")  # starts a new plot

# (c) More text and decorations:
mark(x = 0, y = c(.60, .50), 
     labels = c("Highlighting text is simple", "and effective"),
     cex = 1.5, col_bg = c(pal_seeblau[[2]], pal_seeblau[[1]]))

mark(labels = c("It is also flexible", "but to be handled with care"),
     x = .4, y = .3, y_layout = "flush", cex = 1.2,
     col = c("white", "black"), col_bg = c(pal_seeblau[[5]], "gold"))

}
\seealso{
\code{\link{slide}} and \code{\link{xbox}} to create simple plots (without text).

Other text functions: 
\code{\link{post}()},
\code{\link{uline}()},
\code{\link{url_unikn}()}
}
\concept{text functions}
