% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unigd.R
\name{ugd_id}
\alias{ugd_id}
\title{Query unigd plot IDs}
\usage{
ugd_id(index = 0, limit = 1, which = dev.cur(), state = FALSE)
}
\arguments{
\item{index}{Plot index. If this is set to \code{0}, the last page will be
selected.}

\item{limit}{Limit the number of returned IDs. If this is set to a
value > 1 the returned type is a list if IDs. Set to \code{0} for all.}

\item{which}{Which device (ID).}

\item{state}{Include the current device state in the returned result
(see also: \code{\link[=ugd_state]{ugd_state()}}).}
}
\value{
List containing static plot IDs.
}
\description{
Query unigd graphics device static plot IDs.
Available plot IDs starting from \code{index} will be returned.
\code{limit} specifies the number of plots.
This function will only work after starting a device with \code{\link[=ugd]{ugd()}}.
}
\examples{
ugd() # Initialize graphics device

# Page 1
plot.new()
text(.5, .5, "#1")

# Page 2
plot.new()
text(.5, .5, "#2")

# Page 3
plot.new()
text(.5, .5, "#3")

third <- ugd_id() # Get ID of page 3 (last page)
second <- ugd_id(2) # Get ID of page 2
all <- ugd_id(1, limit = Inf) # Get all IDs

ugd_remove(1) # Remove page 1
ugd_render(second) # Render page 2

dev.off() # Close device
}
