% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sphere.R
\name{runif_on_spherePatch}
\alias{runif_on_spherePatch}
\title{Uniform sampling on a spherical patch}
\usage{
runif_on_spherePatch(n, r = 1, phi1, phi2, theta1, theta2)
}
\arguments{
\item{n}{number of simulations}

\item{r}{radius}

\item{phi1, phi2}{numbers defining the latitudinal angle range}

\item{theta1, theta2}{numbers defining the longitudinal angle range}
}
\value{
The simulations in a \code{n} times \code{3} matrix.
}
\description{
Uniform sampling on a spherical patch (in dimension 3).
}
\details{
A sphere patch is the part of the sphere whose polar angles
\code{theta} and \code{phi} satisfy
\code{0 <= theta1 <= theta <= theta2 <= 2*pi} and
\code{0 <= phi1 <= phi <= phi2 <= pi}.
}
\examples{
# sampling on the first orthant:
sims <- runif_on_spherePatch(100, phi1=0, phi2=pi/2, theta1=0, theta2=pi/2)
\dontrun{library(rgl)
spheres3d(0, 0, 0, color="red", alpha=0.5)
points3d(sims)}
}
\seealso{
\code{\link{runif_on_stri}} for sampling on a spherical triangle.
}
