% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_project.R
\name{create_unity_project}
\alias{create_unity_project}
\title{Create a new Unity project.}
\usage{
create_unity_project(path, quit = TRUE, unity = NULL)
}
\arguments{
\item{path}{The path to create a new Unity project at.}

\item{quit}{Logical: quit Unity after creating the project?}

\item{unity}{The path to the Unity executable on your system (importantly,
\emph{not} the UnityHub executable). If \code{NULL}, checks to see if the environment
variable or option \code{unifir_unity_path} is set; if so, uses that path
(preferring the environment variable over the option if the two disagree).}
}
\value{
TRUE, invisibly.
}
\description{
Create a new Unity project.
}
\examples{
\donttest{

if (interactive()) create_unity_project(file.path(tempdir(), "project"))
}

}
\seealso{
Other utilities: 
\code{\link{add_default_player}()},
\code{\link{add_prop}()},
\code{\link{find_unity}()},
\code{\link{get_asset}()},
\code{\link{load_png}()},
\code{\link{load_scene}()},
\code{\link{new_scene}()},
\code{\link{read_raw}()},
\code{\link{save_scene}()},
\code{\link{set_active_scene}()},
\code{\link{validate_path}()},
\code{\link{waiver}()}
}
\concept{utilities}
