% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_asset.R
\name{get_asset}
\alias{get_asset}
\title{Download prefabs for Unity}
\usage{
get_asset(asset, directory = NULL)
}
\arguments{
\item{asset}{The asset to download. Available asset names are provided in
\link{available_assets}.}

\item{directory}{Optionally, the directory to extract the downloaded models
in. If NULL, the default, saves to \code{tools::R_user_dir("unifir")}.}
}
\description{
This is a simple helper function downloading the assets stored at
https://github.com/mikemahoney218/unity_assets .
}
\examples{

if (interactive()) {
  get_asset(asset = "tree_1", directory = tempdir())
}
}
\seealso{
Other utilities: 
\code{\link{add_default_player}()},
\code{\link{add_prop}()},
\code{\link{create_unity_project}()},
\code{\link{find_unity}()},
\code{\link{load_png}()},
\code{\link{load_scene}()},
\code{\link{new_scene}()},
\code{\link{read_raw}()},
\code{\link{save_scene}()},
\code{\link{set_active_scene}()},
\code{\link{validate_path}()},
\code{\link{waiver}()}
}
\concept{utilities}
