% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Potsdam.R
\docType{data}
\name{uni_potsdam}
\alias{uni_potsdam}
\title{Colors of the University of Potsdam, Germany}
\format{
An object of class \code{character} of length 9.
}
\source{
Color definitions are based on the 
\href{https://www.uni-potsdam.de/fileadmin/projects/zim/files/Printmedien_Leitfaden_2020-21.pdf}{University of Potsdam's Leitfaden (pdf)}.
}
\usage{
uni_potsdam
}
\value{
A names vector of colors (HEX/HTML codes of type character).
}
\description{
\code{uni_potsdam} provides the nine primary colors
of the \href{https://www.uni-potsdam.de/de/}{University of Potsdam}, Germany.
}
\details{
The 9 primary colors are 
\code{"hks_41"} (defined as HEX #00305e), 
\code{"hks_41_45"} (defined as HEX #818bac), 
\code{"web_color"} (defined as HEX #c1d3e0), 
\code{"faculty_of_law"} (defined as HEX #e4003a), 
\code{"faculty_of_philosophy"} (defined as HEX #8b2939), 
\code{"faculty_of_humanities"} (defined as HEX #f59c00), 
\code{"faculty_of_economics"} (defined as HEX #52822f), 
\code{"faculty_of_mathematics"} (defined as HEX #0080b5), and 
\code{"faculty_of_digital_engineering"} (defined as HEX #5A5F62).

\code{uni_potsdam} uses the HEX color definitions.
}
\examples{
uni_potsdam
unikn::seecol(uni_potsdam, main = "University of Potsdam") # view color palette.

}
\seealso{
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other German university color palettes: 
\code{\link{fu_0}},
\code{\link{fu_1}},
\code{\link{fu_2}},
\code{\link{fu_3}},
\code{\link{hu_1_2022}},
\code{\link{hu_1_digital}},
\code{\link{hu_1}},
\code{\link{hu_2_2022}},
\code{\link{hu_2}},
\code{\link{hu_3_accent}},
\code{\link{lmu_1}},
\code{\link{lmu_2}},
\code{\link{lmu_3}},
\code{\link{rptu}},
\code{\link{uni_bonn_1}},
\code{\link{uni_bonn_2}},
\code{\link{uni_freiburg_0}},
\code{\link{uni_freiburg_1}},
\code{\link{uni_freiburg_2}},
\code{\link{uni_freiburg_blue}},
\code{\link{uni_freiburg_br}},
\code{\link{uni_freiburg_grey}},
\code{\link{uni_freiburg_info}},
\code{\link{uni_goettingen_1}},
\code{\link{uni_goettingen_2}},
\code{\link{uni_goettingen_3}},
\code{\link{uni_hamburg_1}},
\code{\link{uni_hamburg_2}},
\code{\link{uni_heidelberg}},
\code{\link{uni_jena_1}},
\code{\link{uni_jena_2}},
\code{\link{uni_kassel}},
\code{\link{uni_kiel_1}},
\code{\link{uni_kiel_2}},
\code{\link{uni_koeln_1}},
\code{\link{uni_koeln_2}},
\code{\link{uni_konstanz_1}},
\code{\link{uni_konstanz_2}},
\code{\link{uni_mannheim_1}},
\code{\link{uni_mannheim_2}},
\code{\link{uni_regensburg_1}},
\code{\link{uni_regensburg_2}},
\code{\link{uni_regensburg_3}},
\code{\link{uni_stuttgart_1}},
\code{\link{uni_stuttgart_print}},
\code{\link{uni_ulm_1}},
\code{\link{uni_ulm_2}}
}
\author{
\strong{unicol}, 2023-07-21.
}
\concept{German university color palettes}
\keyword{datasets}
