% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Concordia.R
\docType{data}
\name{conc_1}
\alias{conc_1}
\title{Primary colors of Concordia University, Canada}
\format{
An object of class \code{character} of length 8.
}
\source{
Color definitions are based on 
\href{https://www.concordia.ca/web/design/ui-kit-style-guide-accessibility/web-palette-new.html}{Concordia's NEW web colour palette}.
}
\usage{
conc_1
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{conc_1} provides the eight primary colors 
of the \href{https://www.concordia.ca/}{Concordia University}, Canada.
}
\details{
The eight primary colors are
\code{"burgundy"}            (defined as HEX #912338), 
\code{"magenta_concordia"}   (defined as HEX #db0272), 
\code{"orange_concordia"}    (defined as HEX #da3a16),
\code{"mauve"}               (defined as HEX #573996),
\code{"dark_blue"}           (defined as HEX #004085),
\code{"blue_condordia"}      (defined as HEX #0072a8),
\code{"turquoise_concordia"} (defined as HEX #057d78), and
\code{"grenn"}               (defined as HEX #508212).

\code{conc_1} uses the HEX color definitions.
}
\examples{
conc_1
unikn::seecol(conc_1, main = "Concordia University") # view color palette

}
\seealso{
\code{\link{conc_2}} for secondary colors of Concordia University;
\code{\link{conc_3}} for background colors of Concordia University;
\code{\link{conc_4}} for neutral colors of Concordia University;
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other Canadian university color palettes: 
\code{\link{carleton}},
\code{\link{conc_2}},
\code{\link{conc_3}},
\code{\link{conc_4}},
\code{\link{guelph}},
\code{\link{laval}},
\code{\link{manitoba_1}},
\code{\link{manitoba_2}},
\code{\link{mcgill_brights}},
\code{\link{mcgill_darks}},
\code{\link{mcgill_grey}},
\code{\link{mcgill_muted}},
\code{\link{mcgill_pastels}},
\code{\link{mcgill_red}},
\code{\link{mcmaster_brighterworld}},
\code{\link{mcmaster_heritage}},
\code{\link{mun_1}},
\code{\link{mun_2}},
\code{\link{queensu_1}},
\code{\link{queensu_2}},
\code{\link{sfu_brand}},
\code{\link{ubc_1}},
\code{\link{ucalgary_1}},
\code{\link{ucalgary_2}},
\code{\link{ucalgary_accent}},
\code{\link{ucalgary_warmgreys}},
\code{\link{uottawa}},
\code{\link{utoronto}},
\code{\link{uvic_complementary}},
\code{\link{uvic_core}},
\code{\link{uwaterloo_arts}},
\code{\link{uwaterloo_engineering}},
\code{\link{uwaterloo_environment}},
\code{\link{uwaterloo_health}},
\code{\link{uwaterloo_main}},
\code{\link{uwaterloo_math}},
\code{\link{uwaterloo_science}},
\code{\link{western_uni}},
\code{\link{yorku_1}},
\code{\link{yorku_2}}
}
\author{
\strong{unicol}, 2023-06-26.
}
\concept{Canadian university color palettes}
\keyword{datasets}
