% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Irvine.R
\docType{data}
\name{uci_2}
\alias{uci_2}
\title{Secondary colors of the University of California, Irvine, USA}
\format{
An object of class \code{character} of length 7.
}
\source{
Color definitions are based on 
\href{https://brand.uci.edu/master-branding/color-palette/}{UCI's brand guide}.
}
\usage{
uci_2
}
\value{
A names vector of colors (HEX/HTML codes of type character).
}
\description{
\code{uci_2} provides the 7 secondary colors
of the \href{https://www.uci.edu}{University of California, Irvine}, USA.
}
\details{
The 7 secondary colors are
\code{"light_blue"} (defined as HEX #6aa2b8),
\code{"light_gray"} (defined as HEX #c6beb5),
\code{"dark_blue"} (defined as HEX #1b3d6d),
\code{"orange"} (defined as HEX #f78d2d), 
\code{"light_yellow"} (defined as HEX #f7eb5f), 
\code{"dark_gray"} (defined as HEX #555759), and 
\code{"lime_green"} (defined as HEX #7ab800). 

\code{uci_2} uses the HEX color definitions.
}
\examples{
uci_2
unikn::seecol(uci_2, main = "University of California, Irvine") # view color palette

}
\seealso{
\code{\link{uci_1}} for primary colors of UC Irvine;
\code{\link{uci_3}} for tertiary colors of UC Irvine;
\code{\link{uci_4}} for neutral colors of the UC Irvine; 
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other university color palettes.: 
\code{\link{asu_2}},
\code{\link{asu_3}},
\code{\link{dartmouth_2}},
\code{\link{dartmouth_3}},
\code{\link{limerick_2}},
\code{\link{notredame_2}},
\code{\link{trinity_2}},
\code{\link{uflorida_2}},
\code{\link{vanderbilt_2}}
}
\author{
\strong{unicol}, 2320-07-13.
}
\concept{university color palettes.}
\keyword{datasets}
