% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Arizona.R
\docType{data}
\name{asu_3}
\alias{asu_3}
\title{Grayscale colors of the Arizona State University, USA}
\format{
An object of class \code{character} of length 9.
}
\source{
Color definitions are based on 
\href{https://brandguide.asu.edu/brand-elements/design/color}{ASU's brand guide}.
}
\usage{
asu_3
}
\value{
A names vector of colors (HEX/HTML codes of type character).
}
\description{
\code{asu_3} provides the nine grayscale colors
of the \href{https://www.asu.edu}{Arizona State University}, USA.
}
\details{
The 9 grayscale colors are 
\code{"asu_black"} (defined as HEX #000000),
\code{"gray1"} (defined as HEX #191919),
\code{"gray2"} (defined as HEX #484848),
\code{"asu_gray"} (defined as HEX #747474), 
\code{"gray4"} (defined as HEX #BFBFBF), 
\code{"gray5"} (defined as HEX #D0D0D0), 
\code{"gray6"} (defined as HEX #E8E8E8), 
\code{"gray7"} (defined as HEX #FAFAFA), and 
\code{"asu_white"} (defined as HEX #FFFFFF). 

\code{asu_3} uses the HEX color definitions.
}
\examples{
asu_3
unikn::seecol(asu_3, main = "Arizona State University") # view color palette

}
\seealso{
\code{\link{asu_1}} for ASU's primary colors;
\code{\link{asu_2}} for ASU's secondary colors;
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other university color palettes.: 
\code{\link{asu_2}},
\code{\link{dartmouth_2}},
\code{\link{dartmouth_3}},
\code{\link{limerick_2}},
\code{\link{notredame_2}},
\code{\link{trinity_2}},
\code{\link{uci_2}},
\code{\link{uflorida_2}},
\code{\link{vanderbilt_2}}
}
\author{
\strong{unicol}, 2320-07-13.
}
\concept{university color palettes.}
\keyword{datasets}
