% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_msg}
\alias{umx_msg}
\title{Print the name and compact contents of variable.}
\usage{
umx_msg(x)
}
\arguments{
\item{x}{the thing you want to pretty-print}
}
\value{
\itemize{
\item NULL
}
}
\description{
Helper function to ease debugging with console notes like:  "ObjectName = \<Object Value\>".
This is primarily useful for inline debugging, where seeing, e.g., "nVar = 3" can be useful.
The ability to say \code{umx_msg(nVar)} makes this easy.
}
\examples{
a = "brian"
umx_msg(a)
b = c("brian", "sally", "jane")
umx_msg(b)
umx_msg(mtcars)
}
\references{
\itemize{
\item \url{https://tbates.github.io},  \url{https://github.com/tbates/umx}
}
}
\seealso{
Other Miscellaneous Utility Functions: 
\code{\link{install.OpenMx}()},
\code{\link{libs}()},
\code{\link{qm}()},
\code{\link{umx}},
\code{\link{umxLav2RAM}()},
\code{\link{umxModelNames}()},
\code{\link{umxRAM2Lav}()},
\code{\link{umxVersion}()},
\code{\link{umx_array_shift}()},
\code{\link{umx_find_object}()},
\code{\link{umx_lower.tri}()},
\code{\link{umx_open_CRAN_page}()},
\code{\link{umx_pad}()},
\code{\link{umx_print}()}
}
\concept{Miscellaneous Utility Functions}
