% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_print}
\alias{umx_print}
\title{Print tables in a range of formats (markdown default, see \code{\link[=umx_set_table_format]{umx_set_table_format()}} for other formats)
or as a web browser table.}
\usage{
umx_print(
  x,
  digits = getOption("digits"),
  quote = FALSE,
  na.print = "",
  zero.print = "0",
  justify = "none",
  suppress = NULL,
  file = c(NA, "tmp.html"),
  kableExtra = TRUE,
  append = FALSE,
  sortableDF = TRUE,
  report = c("html", "markdown"),
  html_font = NULL,
  style = c("paper", "material_dark", "classic", "classic_2", "minimal", "material"),
  bootstrap_options = c("hover", "bordered", "condensed", "responsive"),
  lightable_options = "striped",
  both = TRUE,
  ...
)
}
\arguments{
\item{x}{A data.frame to print (matrices will be coerced to data.frame)}

\item{digits}{The number of decimal places to print (getOption("digits"))}

\item{quote}{Parameter passed to print (FALSE)}

\item{na.print}{How to display NAs (default = "")}

\item{zero.print}{How to display 0 values (default = "0")}

\item{justify}{Parameter passed to print (defaults to "none")}

\item{suppress}{minimum numeric value to print (NULL = print all values, no matter how small)}

\item{file}{whether to write to a file (defaults to NA (no file). Use "html" to open table in browser.}

\item{kableExtra}{Whether to print the table using kableExtra (if html)}

\item{append}{If html, is this appended to file? (FALSE)}

\item{sortableDF}{If html, is table sortable? (TRUE)}

\item{report}{How to report the results. "html" = open in browser.}

\item{html_font}{Override style font. e.g. "Times" or '"Arial Narrow", arial, helvetica, sans-s'}

\item{style}{The style for the table "paper","material_dark" etc.}

\item{bootstrap_options}{border etc.}

\item{lightable_options}{striped}

\item{both}{If html, is table also printed as markdown? (TRUE)}

\item{...}{Optional parameters for print}
}
\value{
\itemize{
\item A dataframe of text
}
}
\description{
To aid interpretability of printed tables from OpenMx (and elsewhere)
you can change how NA and zero appear, and suppressing values below a certain cut-off.
By default, Zeros have the decimals suppressed, and NAs are suppressed altogether.
}
\examples{
umx_print(mtcars[1:10,], digits = 2, zero.print = ".", justify = "left")
umx_print(mtcars[1,1:2], digits = 2, zero.print = "")
\dontrun{
umx_print(mtcars[1:10,], file = "html")
umx_print(mtcars[1:10,], file = "tmp.html")
}
}
\seealso{
\code{\link[=umx_msg]{umx_msg()}}, \code{\link[=umx_set_table_format]{umx_set_table_format()}}

Other Miscellaneous Utility Functions: 
\code{\link{install.OpenMx}()},
\code{\link{qm}()},
\code{\link{umxBrownie}()},
\code{\link{umxLav2RAM}()},
\code{\link{umxRAM2Lav}()},
\code{\link{umxVersion}()},
\code{\link{umx_array_shift}()},
\code{\link{umx_find_object}()},
\code{\link{umx_msg}()},
\code{\link{umx_open_CRAN_page}()},
\code{\link{umx_pad}()},
\code{\link{umx_score_scale}()},
\code{\link{umx}}
}
\concept{Miscellaneous Utility Functions}
