% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_lower.tri}
\alias{umx_lower.tri}
\title{Get values from lower triangle of a matrix}
\usage{
umx_lower.tri(x, diag = FALSE)
}
\arguments{
\item{x}{a \code{\link[=matrix]{matrix()}} from which to extract values.}

\item{diag}{whether to include the diagonal (default = FALSE).}
}
\value{
\itemize{
\item values of cells of the lower triangle.
}
}
\description{
\code{umx_lower.tri} is a wrapper for \code{\link[=lower.tri]{lower.tri()}} and a selection to return
values from a lower matrix in one step.
}
\examples{
x = qm(1,2,3|4,5,6|7,8,9)
umx_lower.tri(x)
# 4,7,8
umx_lower.tri(x, diag=TRUE) # 1 4 7 5 8 9

}
\seealso{
\itemize{
\item \code{\link[=lower.tri]{lower.tri()}}
}

Other Miscellaneous Utility Functions: 
\code{\link{install.OpenMx}()},
\code{\link{libs}()},
\code{\link{qm}()},
\code{\link{umxLav2RAM}()},
\code{\link{umxModelNames}()},
\code{\link{umxRAM2Lav}()},
\code{\link{umxVersion}()},
\code{\link{umx_array_shift}()},
\code{\link{umx_find_object}()},
\code{\link{umx_msg}()},
\code{\link{umx_open_CRAN_page}()},
\code{\link{umx_pad}()},
\code{\link{umx_print}()},
\code{\link{umx}}
}
\concept{Miscellaneous Utility Functions}
