% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_run_modify.R
\name{umxSetParameters}
\alias{umxSetParameters}
\title{Change or fix parameters (e.g. their values, labels, bounds, ..) in a model.}
\usage{
umxSetParameters(
  model,
  labels,
  free = NULL,
  values = NULL,
  newlabels = NULL,
  lbound = NULL,
  ubound = NULL,
  indep = FALSE,
  strict = TRUE,
  name = NULL,
  regex = FALSE,
  test = FALSE
)
}
\arguments{
\item{model}{an \code{\link[=mxModel]{mxModel()}} to WITH}

\item{labels}{= labels to find}

\item{free}{= new value for free}

\item{values}{= new values}

\item{newlabels}{= newlabels}

\item{lbound}{= value for lbound}

\item{ubound}{= value for ubound}

\item{indep}{= whether to look in indep models}

\item{strict}{whether to complain if labels not found}

\item{name}{= new name for the returned model}

\item{regex}{patterns to match for labels (or if TRUE, use labels as regular expressions)}

\item{test}{Just show what you would do? (defaults to FALSE)}
}
\value{
\itemize{
\item \code{\link[=mxModel]{mxModel()}}
}
}
\description{
\code{umxSetParameters} is used to alter values, and other parameter properties in an \code{\link[=mxModel]{mxModel()}}.
A common use is setting new values and changing parameters from free to false.
\emph{Note}: If you just want to modify and re-run a model, you probably want \code{\link[=umxModify]{umxModify()}}.
}
\details{
Using \code{umxSetParameters}, you use \verb{labels=} to select the parameters you want to update.
You can set their free/fixed state with \verb{free=}, and set new values with \verb{values = }. Likewise
for bounds.

\code{umxSetParameters} supports pattern matching (regular expressions) to select labels. Set \verb{regex=}
to a regular expression matching the labels you want to select. e.g. "G_to_.*" would match
"G_to_anything".

\strong{Details}
Internally, \code{umxSetParameters} is equivalent to a call to \code{omxSetParameters} where you
have the ability to generate a pattern-based label list,
and, because this can create duplicate labels, we also call \code{\link[=omxAssignFirstParameters]{omxAssignFirstParameters()}}
to equate the start values for parameters which now have identical labels.
}
\examples{
require(umx)
data(demoOneFactor)
latents  = c("G")
manifests = names(demoOneFactor)
m1 = umxRAM("One Factor", data = mxData(demoOneFactor[1:80,], type = "raw"),
	umxPath(from = latents, to = manifests),
	umxPath(v.m. = manifests),
	umxPath(v1m0 = latents)
)
parameters(m1)
# Match all labels
umxSetParameters(m1, regex = "^", newlabels= "m1_", test = TRUE)
# Change path to x1 to x2, equating these two paths
m2 = umxSetParameters(m1, "G_to_x1", newlabels= "G_to_x2", test = FALSE)
parameters(m2) 
}
\references{
\itemize{
\item \url{https://github.com/tbates/umx}, \url{https://tbates.github.io}
}
}
\seealso{
\itemize{
\item \code{\link[=umxModify]{umxModify()}}, \code{\link[=umxLabel]{umxLabel()}}
}

Other Modify or Compare Models: \code{\link{umxEquate}()},
  \code{\link{umxFixAll}()}, \code{\link{umxMI}()},
  \code{\link{umxModify}()},
  \code{\link{umxUnexplainedCausalNexus}()},
  \code{\link{umx}}
}
\concept{Modify or Compare Models}
