% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umxPlotACEcov}
\alias{umxPlotACEcov}
\alias{plot.MxModelACEcov}
\title{Make a graphical display of an ACE model with covariates.}
\usage{
umxPlotACEcov(x = NA, file = "name", digits = 2, means = FALSE,
  std = TRUE, ...)
}
\arguments{
\item{x}{\code{\link{mxModel}} to plot (created by umxACE in order to inherit the MxModelACE class)}

\item{file}{The name of the dot file to write: NA = none; "name" = use the name of the model}

\item{digits}{How many decimals to include in path loadings (default is 2)}

\item{means}{Whether to show means paths (default is FALSE)}

\item{std}{Whether to standardize the model (default is TRUE)}

\item{...}{Additional (optional) parameters}
}
\value{
- optionally return the dot code
}
\description{
Make a graphical display of an ACE model with covariates.
}
\examples{
require(umx)
# BMI ?twinData from Australian twins. 
# Cohort 1 Zygosity 1 == MZ females 3 == DZ females
data(twinData)
# Pick the variables. We will use base names (i.e., "bmi") and set suffix.
selDVs  = c("bmi")
selCovs = c("ht")
selVars = umx_paste_names(c(selDVs, selCovs), sep = "", suffixes= 1:2)
# Just top few pairs so example runs quickly
mzData = subset(twinData, zygosity == "MZFF", selVars)[1:100, ]
dzData = subset(twinData, zygosity == "DZFF", selVars)[1:100, ]
m1 = umxACEcov(selDVs = selDVs, selCovs = selCovs, dzData = dzData, mzData = mzData, 
	 sep = "", autoRun = TRUE)
plot(m1)
plot(m1, std = FALSE) # don't standardize
}
\references{
- \url{http://tbates.github.io}
}
\seealso{
- \code{\link{plot}()}, \code{\link{umxSummary}()} work for IP, CP, GxE, SAT, and ACE models.

- \code{\link{umxACE}}

Other Plotting functions: \code{\link{plot.MxModel}},
  \code{\link{umxPlotACEv}}, \code{\link{umxPlotACE}},
  \code{\link{umxPlotCPnew}}, \code{\link{umxPlotCP}},
  \code{\link{umxPlotGxEbiv}}, \code{\link{umxPlotGxE}},
  \code{\link{umxPlotIP}}, \code{\link{umxPlotSimplex}},
  \code{\link{umx}}
}
