% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umxPlotIP}
\alias{umxPlotIP}
\alias{plot.MxModelIP}
\title{Draw a graphical figure for a Independent Pathway model}
\usage{
umxPlotIP(x = NA, file = "name", digits = 2, means = FALSE,
  std = TRUE, format = c("current", "graphviz", "DiagrammeR"), ...)
}
\arguments{
\item{x}{The \code{\link{umxIP}} model to plot}

\item{file}{The name of the dot file to write: NA = none; "name" = use the name of the model}

\item{digits}{How many decimals to include in path loadings (defaults to 2)}

\item{means}{Whether to show means paths (defaults to FALSE)}

\item{std}{whether to standardize the model (defaults to TRUE)}

\item{format}{= c("current", "graphviz", "DiagrammeR")}

\item{...}{Optional additional parameters}
}
\value{
- optionally return the dot code
}
\description{
Options include digits (rounding), showing means or not, standardization, and which output format is desired.
}
\examples{
\dontrun{
plot(model)
umxPlotIP(model, file = NA)
}
}
\references{
- \url{http://tbates.github.io}
}
\seealso{
- \code{\link{plot}()}, \code{\link{umxSummary}()} work for IP, CP, GxE, SAT, and ACE models.

- \code{\link{umxIP}}

Other Plotting functions: \code{\link{plot.MxModel}},
  \code{\link{umxPlotACEcov}}, \code{\link{umxPlotACEv}},
  \code{\link{umxPlotACE}}, \code{\link{umxPlotCP}},
  \code{\link{umxPlotGxE_biv}}, \code{\link{umxPlotGxE}},
  \code{\link{umxPlotSimplex}}, \code{\link{umx}}
}
