% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lavanify2ram.R
\name{xmu_lavaan_process_group}
\alias{xmu_lavaan_process_group}
\title{lavaan parameter table rows to model}
\usage{
xmu_lavaan_process_group(tab, groupNum)
}
\arguments{
\item{tab}{a parameter table}

\item{groupNum}{group number to filter table on}
}
\value{
- list(plist=plist, latents = latents, manifests = manifests)
}
\description{
Process a set of lavaan tables rows forming a group (Model).
Returns empty arrays if no rows matching the requested group are found.
}
\examples{
tab = lavaan::lavaanify("y~x")
xmu_lavaan_process_group(tab, groupNum = 1)
xmu_lavaan_process_group(tab, groupNum = 0)
}
\seealso{
- \code{\link{umxLav2RAM}}

Other xmu internal not for end user: \code{\link{umxModel}},
  \code{\link{umx}}, \code{\link{xmuHasSquareBrackets}},
  \code{\link{xmuLabel_MATRIX_Model}},
  \code{\link{xmuLabel_Matrix}},
  \code{\link{xmuLabel_RAM_Model}}, \code{\link{xmuMI}},
  \code{\link{xmuMakeDeviationThresholdsMatrices}},
  \code{\link{xmuMakeOneHeadedPathsFromPathList}},
  \code{\link{xmuMakeTwoHeadedPathsFromPathList}},
  \code{\link{xmuMaxLevels}}, \code{\link{xmuMinLevels}},
  \code{\link{xmuPropagateLabels}},
  \code{\link{xmu_assemble_twin_supermodel}},
  \code{\link{xmu_check_levels_identical}},
  \code{\link{xmu_clean_label}},
  \code{\link{xmu_dot_make_paths}},
  \code{\link{xmu_dot_make_residuals}},
  \code{\link{xmu_dot_maker}},
  \code{\link{xmu_dot_move_ranks}},
  \code{\link{xmu_dot_rank_str}},
  \code{\link{xmu_make_mxData}},
  \code{\link{xmu_make_top_twin}},
  \code{\link{xmu_model_needs_means}},
  \code{\link{xmu_safe_run_summary}},
  \code{\link{xmu_set_sep_from_suffix}},
  \code{\link{xmu_simplex_corner}},
  \code{\link{xmu_start_value_list}},
  \code{\link{xmu_starts}}
}
\concept{xmu internal not for end user}
