% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xmu.R
\name{xmu_check_variance}
\alias{xmu_check_variance}
\title{Check the minimum variance in data frame}
\usage{
xmu_check_variance(data, minVar = 0.1, maxVarRatio = 1000)
}
\arguments{
\item{data}{the data frame to check}

\item{minVar}{Minimum allowed variance in variables before warning user variances differ too much.}

\item{maxVarRatio}{Maximum allowed ratio of variance in data before warning user variances differ too much.}
}
\value{
-
}
\description{
Check that each variable exceeds a minimum variance and all are on compatible scales. Let the user know what to do if not.
}
\examples{
data(twinData)
xmu_check_variance(twinData[, c("wt1", "ht1", "wt2", "ht2")])
twinData[,c("ht1", "ht2")]= twinData[,c("ht1", "ht2")] * 100
xmu_check_variance(twinData[, c("wt1", "ht1", "wt2", "ht2")])
}
\seealso{
Other Miscellaneous Utility Functions: \code{\link{install.OpenMx}},
  \code{\link{qm}}, \code{\link{umxBrownie}},
  \code{\link{umxFactor}}, \code{\link{umxVersion}},
  \code{\link{umx_array_shift}},
  \code{\link{umx_cell_is_on}},
  \code{\link{umx_cont_2_quantiles}},
  \code{\link{umx_find_object}}, \code{\link{umx_make}},
  \code{\link{umx_msg}}, \code{\link{umx_open_CRAN_page}},
  \code{\link{umx_pad}}, \code{\link{umx_pb_note}},
  \code{\link{umx_print}}, \code{\link{umx_scale}},
  \code{\link{umx_score_scale}}, \code{\link{umx}}
}
\concept{Miscellaneous Utility Functions}
