% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umxSummaryIP}
\alias{umxSummaryIP}
\alias{umxSummary.MxModel.IP}
\title{Present the results of an independent-pathway twin model in table and graphical form}
\usage{
umxSummaryIP(model, digits = 2, file = getOption("umx_auto_plot"),
  returnStd = FALSE, std = TRUE, showRg = FALSE, comparison = NULL,
  CIs = FALSE, ...)
}
\arguments{
\item{model}{A fitted \code{\link{umxIP}} model to summarize}

\item{digits}{round to how many digits (default = 2)}

\item{file}{The name of the dot file to write: NA = none; "name" = use the name of the model}

\item{returnStd}{Whether to return the standardized form of the model (default = FALSE)}

\item{std}{= Whether to show the standardized model (TRUE)}

\item{showRg}{= whether to show the genetic correlations (FALSE)}

\item{comparison}{Whether to run mxCompare on a comparison model (NULL)}

\item{CIs}{Confidence intervals (F)}

\item{...}{Optional additional parameters}
}
\value{
- optional \code{\link{mxModel}}
}
\description{
Summarize a Independent Pathway model, as returned by \code{\link{umxIP}}
}
\examples{
require(umx)
data(twinData)
selDVs = c("ht1", "wt1", "ht2", "wt2")
mzData <- subset(twinData, zygosity == "MZFF")
dzData <- subset(twinData, zygosity == "DZFF")
m1 = umxIP(selDVs = selDVs, dzData = dzData, mzData = mzData)
m1 = umxRun(m1)
umxSummaryIP(m1)
plot(m1)
\dontrun{
umxSummaryIP(m1, digits = 2, file = "Figure3", showRg = FALSE, CIs = TRUE);
}
}
\references{
- \url{http://github.com/tbates/umx}, \url{http://tbates.github.io}
}
\seealso{
- \code{\link{umxIP}()}, \code{\link{plot}()}, \code{\link{umxSummary}()} work for IP, CP, GxE, SAT, and ACE models.

Other Twin Modeling Functions: \code{\link{umxACE_cov_fixed}},
  \code{\link{umxACEcov}}, \code{\link{umxACEv}},
  \code{\link{umxACE}}, \code{\link{umxCP}},
  \code{\link{umxGxE_biv}}, \code{\link{umxGxE_window}},
  \code{\link{umxGxE}}, \code{\link{umxIP}},
  \code{\link{umxSexLim}}, \code{\link{umxSummaryACEcov}},
  \code{\link{umxSummaryACEv}},
  \code{\link{umxSummaryACE}}, \code{\link{umxSummaryCP}},
  \code{\link{umxSummaryGxE_biv}},
  \code{\link{umxSummaryGxE}},
  \code{\link{umxSummarySexLim}}, \code{\link{umx}},
  \code{\link{xmu_twin_check}}
}
