% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umxConfint}
\alias{umxConfint}
\title{Get confidence intervals from an MxModel}
\usage{
umxConfint(object, parm = c("existing", "all", "vector of names"),
  level = 0.95, run = FALSE, showErrorCodes = FALSE, ...)
}
\arguments{
\item{object}{An \code{\link{mxModel}}, possibly already containing \code{\link{mxCI}}s that have been \code{\link{mxRun}} with intervals = TRUE))}

\item{parm}{A specification of which parameters are to be given confidence intervals. Can be "existing", "all", or a vector of names.}

\item{level}{The confidence level required (default = .95)}

\item{run}{Whether to run the model (defaults to FALSE)}

\item{showErrorCodes}{(default = FALSE)}

\item{...}{Additional argument(s) for umxConfint.}
}
\value{
- \code{\link{mxModel}}
}
\description{
Implements confidence interval function for OpenMx models.
Note: Currently requested CIs are added to existing CIs, and all are run, 
even if they already exist in the output. This should change in the future.
}
\details{
Unlike \code{\link{confint}}, if parm is missing, all CIs requested will be added to the model, 
but (because these can take time to run) by default only CIs already computed will be reported.

CIs will be run only if run is TRUE, allowing this function to be used to add
CIs without automatically having to run them.
If parm is empty, and run = FALSE, a message will alert you to add run = TRUE. 
Even a few CIs can take too long to make running the default.
}
\examples{
require(umx)
data(demoOneFactor)
latents = c("G")
manifests = names(demoOneFactor)
m1 <- umxRAM("One Factor", data = mxData(cov(demoOneFactor), type = "cov", numObs = 500),
	umxPath(from = latents, to = manifests),
	umxPath(var = manifests),
	umxPath(var = latents, fixedAt = 1)
)
m2 = umxConfint(m1, "all") # default: CIs added, but user prompted to set run = TRUE
m2 = umxConfint(m2, run = TRUE) # CIs run and reported
# Add CIs for asymmetric paths in RAM model, report them, save m1 with this CI added
m1 = umxConfint(m1, parm = "G_to_x1", run = TRUE) 
# Add CIs for asymmetric paths in RAM model, report them, save m1 with mxCIs added
m1 = umxConfint(m1, parm = "A", run = TRUE)
umxConfint(m1, parm = "existing") # request existing CIs (none added yet...)
}
\references{
- \url{http://www.github.com/tbates/umx}
}
\seealso{
- \code{\link[stats]{confint}}

Other Reporting functions: \code{\link{RMSEA.MxModel}},
  \code{\link{RMSEA.summary.mxmodel}}, \code{\link{RMSEA}},
  \code{\link{extractAIC.MxModel}}, \code{\link{loadings}},
  \code{\link{residuals.MxModel}},
  \code{\link{umxCI_boot}}, \code{\link{umxCI}},
  \code{\link{umxCompare}}, \code{\link{umxExpCov}},
  \code{\link{umxExpMeans}}, \code{\link{umxFitIndices}},
  \code{\link{umxPlotACEv}},
  \code{\link{umxSummary.MxModel}},
  \code{\link{umxSummaryACEv}},
  \code{\link{umxSummaryACE}},
  \code{\link{umxSummarySexLim}},
  \code{\link{umx_drop_ok}},
  \code{\link{umx_standardize_RAM}}
}
