% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umxFactor}
\alias{umxFactor}
\alias{umx_factor}
\title{umxFactor}
\usage{
umxFactor(x = character(), levels = NA, labels = levels, exclude = NA,
  collapse = FALSE, ordered = TRUE, verbose = FALSE)
}
\arguments{
\item{x}{A variable to recode as an mxFactor (see \code{\link{mxFactor}})}

\item{levels}{defaults to NA. UNLIKE mxFactor, if not specified, the existing levels will be used}

\item{labels}{= levels (see \code{\link{mxFactor}})}

\item{exclude}{= NA (see \code{\link{mxFactor}})}

\item{collapse}{= FALSE (see \code{\link{mxFactor}})}

\item{ordered}{= TRUE By default return an ordered mxFactor}

\item{verbose}{Whether to tell user about such things as coercing to factor}
}
\value{
- \code{\link{mxFactor}}
}
\description{
A convenient version of \code{\link{mxFactor}} supporting the common 
case in which the factor levels are those in the variable.
}
\examples{
x = umxFactor(letters) # just do it
str(x)
x = umxFactor(letters, verbose = TRUE) # report coercions
x = umxFactor(letters, ordered = FALSE) # non-ordered factor like factor(x), but handles data.frames
# Dataframe example:
x = umx_factor(mtcars[,c("cyl", "am")], ordered = FALSE) 
}
\references{
- \url{https://github.com/tbates/umx}, \url{https://tbates.github.io}
}
\seealso{
Other Data Functions: \code{\link{umxCovData}},
  \code{\link{umxHetCor}},
  \code{\link{umxPadAndPruneForDefVars}},
  \code{\link{umx_as_numeric}},
  \code{\link{umx_cont_2_quantiles}},
  \code{\link{umx_cov2raw}}, \code{\link{umx_lower2full}},
  \code{\link{umx_make_MR_data}},
  \code{\link{umx_make_bin_cont_pair_data}},
  \code{\link{umx_make_fake_data}},
  \code{\link{umx_merge_CIs}},
  \code{\link{umx_read_lower}}, \code{\link{umx_reorder}},
  \code{\link{umx_residualize}}, \code{\link{umx_round}},
  \code{\link{umx_scale_wide_twin_data}},
  \code{\link{umx_scale}}, \code{\link{umx_swap_a_block}},
  \code{\link{umx}}
}

