% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umxSummaryGxE}
\alias{umxSummary.MxModel.GxE}
\alias{umxSummaryGxE}
\title{umxSummaryGxE}
\usage{
umxSummaryGxE(model = NULL, digits = 2, xlab = NA, location = "topleft",
  separateGraphs = FALSE, dotFilename = NULL, returnStd = NULL,
  showStd = NULL, reduce = FALSE, CIs = NULL, report = c("1", "2",
  "html"), ...)
}
\arguments{
\item{model}{A fitted \code{\link{umxGxE}} model to summarize}

\item{digits}{round to how many digits (default = 2)}

\item{xlab}{label for the x-axis of plot}

\item{location}{default = "topleft"}

\item{separateGraphs}{default = F}

\item{dotFilename}{The name of the dot file to write: NA = none; "name" = use the name of the model}

\item{returnStd}{Whether to return the standardized form of the model (default = FALSE)}

\item{showStd}{Whether to show the standardized model (not implemented! TRUE)}

\item{reduce}{Whether run and tabulate a complete model reduction...(Defaults to FALSE)}

\item{CIs}{Confidence intervals (FALSE)}

\item{report}{"1" = regular, "2" = add descriptive sentences; "html" = open a browser and copyable tables}

\item{...}{Optional additional parameters}
}
\value{
- optional \code{\link{mxModel}}
}
\description{
Summarise a Moderation model, as returned by \code{\link{umxGxE}}
}
\examples{
# The total sample has been subdivided into a young cohort, 
# aged 18-30 years, and an older cohort aged 31 and above.
# Cohort 1 Zygosity is coded as follows 1 == MZ females 2 == MZ males 
# 3 == DZ females 4 == DZ males 5 == DZ opposite sex pairs
require(umx)
data(twinData) 
labList = c("MZFF", "MZMM", "DZFF", "DZMM", "DZOS")
twinData$ZYG = factor(twinData$zyg, levels = 1:5, labels = labList)
twinData$age1 = twinData$age2 = twinData$age
selDVs  = c("bmi1", "bmi2")
selDefs = c("age1", "age2")
selVars = c(selDVs, selDefs)
mzData  = subset(twinData, ZYG == "MZFF", selVars)
dzData  = subset(twinData, ZYG == "DZMM", selVars)
# Exclude cases with missing Def
mzData <- mzData[!is.na(mzData[selDefs[1]]) & !is.na(mzData[selDefs[2]]),]
dzData <- dzData[!is.na(dzData[selDefs[1]]) & !is.na(dzData[selDefs[2]]),]
m1 = umxGxE(selDVs = selDVs, selDefs = selDefs, dzData = dzData, mzData = mzData)
m1 = umxRun(m1)
# Plot Moderation
umxSummaryGxE(m1)
umxSummaryGxE(m1, location = "topright")
umxSummaryGxE(m1, separateGraphs = FALSE)
}
\references{
- \url{https://github.com/tbates/umx}, \url{http://tbates.github.io}
}
\seealso{
- \code{\link{umxGxE}()}, \code{\link{plot}()}, \code{\link{umxSummary}()} work for IP, CP, GxE, and ACE models.

Other Twin Modeling Functions: \code{\link{umxACESexLim}},
  \code{\link{umxACEcov}}, \code{\link{umxACE}},
  \code{\link{umxCF_SexLim}}, \code{\link{umxCP}},
  \code{\link{umxGxE_window}}, \code{\link{umxGxE}},
  \code{\link{umxIP}}, \code{\link{umxPlotCP}},
  \code{\link{umxPlotGxE}}, \code{\link{umxSummaryACEcov}},
  \code{\link{umxSummaryACE}}, \code{\link{umxSummaryCP}},
  \code{\link{umxSummaryIP}},
  \code{\link{umx_make_TwinData}}, \code{\link{umx}}
}

