% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_residualize}
\alias{umx_residualize}
\title{umx_residualize}
\usage{
umx_residualize(var, covs = NULL, suffixes = NULL, data)
}
\arguments{
\item{var}{The base name of the variable you want to residualize. Alternatively, a
regression \code{\link{formula}} containing var on the lhs, and covs on the rhs}

\item{covs}{Covariates to residualize on.}

\item{suffixes}{Suffixes that identify the variable for each twin, i.e. c("_T1", "_T2")
Up to you to check all variables are present!}

\item{data}{The dataframe containing all the variables}
}
\value{
- dataframe with var residualized in place (i.e under its original column name)
}
\description{
Return one or more variables residualised against covs.
}
\details{
This is the same as:

\code{tmp <- residuals(lm(var ~ cov1 + cov2, data = data, na.action = na.exclude))}

Optionally, this also works on wide (ie., twin) data. Just supply suffixes to identify
the paired-wide columns (see examples)
}
\examples{
library(formula.tools)
tmp = mtcars
# Residualise mpg on cylinders and displacement
r1 = umx_residualize("mpg", c("cyl", "disp"), data = tmp)$mpg
r2 = residuals(lm(mpg ~ cyl + disp, data = tmp, na.action = na.exclude))
all(r1 == r2)
# plot(r1 ~ r2)
# formula interface
r1 = umx_residualize(mpg ~ cyl + I(cyl^2) + disp, data = tmp)$mpg
# Same again, but now on wide data (i.e. with family data on each row)
tmp$mpg_T1  = tmp$mpg_T2  = tmp$mpg
tmp$cyl_T1  = tmp$cyl_T2  = tmp$cyl
tmp$disp_T1 = tmp$disp_T2 = tmp$disp
umx_residualize("mpg", c("cyl", "disp"), c("_T1", "_T2"), data = tmp)
}
\references{
- \url{http://tbates.github.io}, \url{https://github.com/tbates/umx}
}
\seealso{
Other Miscellaneous Data Functions: \code{\link{umxCovData}};
  \code{\link{umxHetCor}};
  \code{\link{umxPadAndPruneForDefVars}};
  \code{\link{umx_as_numeric}};
  \code{\link{umx_cont_2_ordinal}};
  \code{\link{umx_cov2raw}}; \code{\link{umx_lower2full}};
  \code{\link{umx_make_bin_cont_pair_data}};
  \code{\link{umx_merge_CIs}};
  \code{\link{umx_read_lower}}; \code{\link{umx_round}};
  \code{\link{umx_scale_wide_twin_data}};
  \code{\link{umx_scale}}; \code{\link{umx_swap_a_block}};
  \code{\link{umx}}, \code{\link{umx-package}}
}

