% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_fake_data}
\alias{umx_fake_data}
\title{umx_fake_data}
\usage{
umx_fake_data(dataset, digits = 2, n = NA, use.names = TRUE,
  use.levels = TRUE, use.miss = TRUE, mvt.method = "eigen",
  het.ML = FALSE, het.suppress = TRUE)
}
\arguments{
\item{dataset}{The original dataset you want to make a simulacrum of}

\item{digits}{= 2}

\item{n}{= NA}

\item{use.names}{= T}

\item{use.levels}{= T}

\item{use.miss}{= T}

\item{mvt.method}{= "eigen"}

\item{het.ML}{= F}

\item{het.suppress}{= T}
}
\value{
- new dataframe
}
\description{
This function takes as argument an existing dataset, which
must be either a matrix or a data frame. Each column of the
dataset must consist either of numeric variables or ordered
factors. When one or more ordered factors are included,
then a heterogeneous correlation matrix is computed using
John Fox's polycor package. Pairwise complete observations
are used for all covariances, and the exact pattern of
missing data present in the input is placed in the output,
provided a new sample size is not requested. Warnings from
the polycor::hetcor function are suppressed.
}
\details{
Author:   Ryne Estabrook
Created:  17 Aug 2010
}
\examples{
fakeCars = umx_fake_data(mtcars)
}
\seealso{
- \code{\link{umxLabel}}, \code{\link{umxRun}}, \code{\link{umxValues}}
}

