% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umxMI}
\alias{umxMI}
\title{umxMI}
\usage{
umxMI(model = NA, matrices = NA, full = TRUE, numInd = NA,
  typeToShow = "both", decreasing = TRUE)
}
\arguments{
\item{model}{An \code{\link{mxModel}} for which to report modification indices}

\item{matrices}{which matrices to test. The default (NA) will test A & S for RAM models}

\item{full}{Change in fit allowing all parameters to move. If FALSE only the parameter under test can move.}

\item{numInd}{How many modifications to report. Use -1 for all. Default (NA) will report all over 6.63 (p = .01)}

\item{typeToShow}{Whether to shown additions or deletions (default = "both")}

\item{decreasing}{How to sort (default = TRUE, decreasing)}
}
\description{
Report modifications which would improve fit.
Notes:
1. Runs much fast with full = FALSE (but this doesn't allow the model to re-fit around the newly-
freed parameter).
2. Compared to mxMI, this function returns top changes, and also suppresses the run message.
3. Finally, of course: see the requirements for (legitimate) post-hoc modeling in \code{\link{mxMI}}
You are almost certainly doing better science when testing competing models rather than modifying a model to fit.
}
\examples{
\dontrun{
require(OpenMx)
data(demoOneFactor)
latents  = c("G")
manifests = names(demoOneFactor)
m1 <- mxModel("One Factor", type = "RAM",
	manifestVars = manifests, latentVars = latents,
	mxPath(from = latents, to = manifests),
	mxPath(from = manifests, arrows = 2),
	mxPath(from = latents, arrows = 2, free = FALSE, values = 1.0),
	mxData(cov(demoOneFactor), type = "cov", numObs = 500)
)
m1 = umxRun(m1, setLabels = TRUE, setValues = TRUE)
umxMI(model)
umxMI(model, numInd=5, typeToShow="add") # valid options are "both|add|delete"
}
}
\references{
- \url{http://www.github.com/tbates/umx}
}
\seealso{
- \code{\link{mxMI}}

Other Modify or Compare Models: \code{\link{parameters}},
  \code{\link{umxGetParameters}}; \code{\link{umxAdd1}};
  \code{\link{umxDrop1}}; \code{\link{umxEquate}};
  \code{\link{umxFixAll}}; \code{\link{umxSetParameters}};
  \code{\link{umxUnexplainedCausalNexus}}
}

