% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knn.R
\name{knn.from.data}
\alias{knn.from.data}
\title{get information about approximate k nearest neighbors from a data matrix}
\usage{
knn.from.data(d, k, metric.function, subsample.k = 0.5)
}
\arguments{
\item{d}{matrix with data}

\item{k}{integer, number of neighbors}

\item{metric.function}{function with signature f(a, b) that returns a metric distance}

\item{subsample.k}{numeric, used for internal tuning of implementation}
}
\value{
list with two components;
indexes - identifies, for each point in dataset, the set of k neighbors
distances - provides distances from each point to those neighbors
num.computed - for diagnostics only, gives the number of distances computed internally
avg.
}
\description{
This implementation uses a randomization scheme and thus produces
results that are nondeterministic and only approximately correct. The
algorithm is roughly inspired by Dong et al, but there are differences.
This is a rough implementation and improvements are possible.
}
\keyword{internal}
