% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAC_plot.R
\name{BAC_plot}
\alias{BAC_plot}
\title{Bland-Altman Change plot}
\usage{
BAC_plot(
  data,
  cols = names(data),
  reliability = NULL,
  pointSize = 2,
  deterioratedColor = "#482576E6",
  unchangedColor = "#25848E80",
  improvedColor = "#7AD151E6",
  zeroLineColor = "black",
  zeroLineType = "dashed",
  ciLineColor = "red",
  ciLineType = "solid",
  conf.level = 0.95,
  theme = ggplot2::theme_minimal(),
  ignoreBias = FALSE,
  iccFromPsych = FALSE,
  iccFromPsychArgs = NULL
)
}
\arguments{
\item{data}{The data frame; if it only has two columns, the first of
which is the pre-change column, \code{cols} can be left empty.}

\item{cols}{The names of the columns with the data; the first is the
column with the pre-change data, the second the column after the change.}

\item{reliability}{The reliability estimate, for example as obtained with
the \code{ICC()} function in the \code{psych()} package; can be omitted, in which
case the intraclass correlation is computed.}

\item{pointSize}{The size of the points in the plot.}

\item{deterioratedColor, unchangedColor, improvedColor}{The colors to use for
cases who deteriorate, stay the same, and improve, respectively.}

\item{zeroLineColor, ciLineColor}{The colors for the line at 0 (no change)
and at the confidence interval bounds (i.e. the point at which a difference
becomes indicative of change given the reliability), respectively.}

\item{zeroLineType, ciLineType}{The line types for the line at 0 (no change)
and at the confidence interval bounds (i.e. the point at which a difference
becomes indicative of change given the reliability), respectively.}

\item{conf.level}{The confidence level of the confidence interval.}

\item{theme}{The ggplot2 theme to use.}

\item{ignoreBias}{Whether to ignore bias (i.e. allow the measurements at
the second time to shift upwards or downwards). If \code{FALSE}, the variance
associated with such a shift is considered error variance (i.e.
'unreliability').}

\item{iccFromPsych}{Whether to compute ICC using the \code{\link[psych:ICC]{psych::ICC()}} function
or not.}

\item{iccFromPsychArgs}{If using the \code{\link[psych:ICC]{psych::ICC()}} function, the arguments
to pass.}
}
\value{
A ggplot2 plot.
}
\description{
Bland-Altman Change plot
}
\examples{
### Create smaller dataset for example
dat <-
  ufs::testRetestSimData[
    1:25,
    c('t0_item1', 't1_item1')
  ];

ufs::BAC_plot(dat, reliability = .5);
ufs::BAC_plot(dat, reliability = .8);
ufs::BAC_plot(dat, reliability = .9);
}
