% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/occuTTD.R
\name{stan_occuTTD}
\alias{stan_occuTTD}
\title{Fit Time-to-detection Occupancy Models}
\usage{
stan_occuTTD(
  psiformula = ~1,
  gammaformula = ~1,
  epsilonformula = ~1,
  detformula = ~1,
  data,
  ttdDist = c("exp", "weibull"),
  linkPsi = c("logit"),
  ...
)
}
\arguments{
\item{psiformula}{Right-hand sided formula for the initial probability of
occupancy at each site.}

\item{gammaformula}{Right-hand sided formula for colonization probability.
Currently ignored as dynamic models are not yet supported.}

\item{epsilonformula}{Right-hand sided formula for extinction probability.
Currently ignored as dynamic models are not yet supported.}

\item{detformula}{Right-hand sided formula for mean time-to-detection.}

\item{data}{\code{unmarkedFrameOccuTTD} object that supplies the data
(see \code{\link{unmarkedFrameOccuTTD}}).}

\item{ttdDist}{Distribution to use for time-to-detection; either
\code{"exp"} for the exponential, or \code{"weibull"} for the Weibull,
which adds an additional shape parameter \eqn{k}.}

\item{linkPsi}{Link function for the occupancy model. Only option is
\code{"logit"} for now, in the future \code{"cloglog"}
will be supported for the complimentary log-log link.}

\item{...}{Arguments passed to the \code{\link{stan}} call, such as
number of chains \code{chains} or iterations \code{iter}}
}
\value{
\code{ubmsFitOccuTTD} object describing the model fit.
}
\description{
Fit time-to-detection occupancy models of Garrard et al.
(2008, 2013). Time-to-detection can be modeled with either an exponential
or Weibull distribution.
}
\examples{
\donttest{
#Simulate data
N <- 500; J <- 1
scovs <- data.frame(elev=c(scale(runif(N, 0,100))),
                    forest=runif(N,0,1),
                    wind=runif(N,0,1))
beta_psi <- c(-0.69, 0.71, -0.5)
psi <- plogis(cbind(1, scovs$elev, scovs$forest) \%*\% beta_psi)
z <- rbinom(N, 1, psi)

Tmax <- 10 #Same survey length for all observations
beta_lam <- c(-2, -0.2, 0.7)
rate <- exp(cbind(1, scovs$elev, scovs$wind) \%*\% beta_lam)
ttd <- rexp(N, rate)
ttd[z==0] <- Tmax #Censor at unoccupied sites
ttd[ttd>Tmax] <- Tmax #Censor when ttd was greater than survey length

#Build unmarkedFrame
umf <- unmarkedFrameOccuTTD(y=ttd, surveyLength=Tmax, siteCovs=scovs)

#Fit model
(fit <- stan_occuTTD(psiformula=~elev+forest, detformula=~elev+wind,
                     data=umf, chains=3, iter=300))
}

}
\references{
Garrard, G.E., Bekessy, S.A., McCarthy, M.A. and Wintle, B.A. 2008.
When have we looked hard enough? A novel method for setting minimum survey effort
protocols for flora surveys. Austral Ecology 33: 986-998.

Garrard, G.E., McCarthy, M.A., Williams, N.S., Bekessy, S.A. and Wintle,
B.A. 2013. A general model of detectability using species traits. Methods in
Ecology and Evolution 4: 45-52.

Kery, Marc, and J. Andrew Royle. 2016. Applied Hierarchical Modeling in
Ecology, Volume 1. Academic Press.
}
\seealso{
\code{\link{occuTTD}}, \code{\link{unmarkedFrameOccuTTD}}
}
