% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{system_set_iiv}
\alias{system_set_iiv}
\title{Set Variability Terms}
\usage{
system_set_iiv(cfg, IIV1, IIV2, value)
}
\arguments{
\item{cfg}{ubiquity system object}

\item{IIV1}{row name of the variance/covariance matrix}

\item{IIV2}{column name of the variance/covariance matrix element}

\item{value}{value to assign to the variance/covariance matrix element}
}
\value{
Ubiquity system object with IIV information set
}
\description{
Set elements of the current variance covariance matrix
specified in the system file with \code{<IIV:?:?> ?}, \code{<IIVCOR:?:?>?}, \code{<IIVSET:?:?> ?}, \code{<IIVCORSET:?:?>?}
}
\examples{
\donttest{
# Creating a system file from the mab_pk example
fr = system_new(file_name        = "system.txt", 
                system_file      = "mab_pk", 
                overwrite        = TRUE, 
                output_directory = tempdir())

# Building the system 
cfg = build_system(system_file  = file.path(tempdir(), "system.txt"),
      output_directory          = file.path(tempdir(), "output"),
      temporary_directory       = tempdir())

# Clearing all inputs
cfg = system_zero_inputs(cfg)

# Setting the covariance element for CL and Vc to 0.03
cfg = system_set_iiv(cfg,
                     IIV1 = "ETACL",
                     IIV2 = "ETAVc",
                     value=0.03)
}
}
\seealso{
\code{\link{system_fetch_iiv}}
}
