% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{system_new_tt_rule}
\alias{system_new_tt_rule}
\title{Titration Rules}
\usage{
system_new_tt_rule(cfg, name, times, timescale)
}
\arguments{
\item{cfg}{ubiquity system object}

\item{name}{name for the titration rule}

\item{times}{list of times when the rule will be evaluated}

\item{timescale}{time scale associated with the titration times (as defined by \code{<TS:?>})}
}
\value{
Ubiquity system object with the titration rule created
}
\description{
Defines a new titration rule and the times when that rule is evaluated
}
\details{
\preformatted{
cfg = system_new_tt_rule(cfg,
                        name      = "rname",
                        times     = c(0, 2, 4),
                        timescale = "weeks")'
}
A titration rule identifies a set of times (\code{times}) and an associated time
scale (\code{timescale}) in which titration events can potentially occur. Any
times scale, as defined in the system file with \code{<TS:?>}, can be used in
place of "weeks" above. The \code{name}, \code{"rname"} above, is used to link the
titration rule to different conditions discussed below. The name should be
a string beginning with a letter, and it can contain any combination of
numbers, letters, and underscores. With the rule created we can then add conditions to that rule.'
}
\seealso{
\code{\link{system_set_tt_cond}}, \code{\link{run_simulation_titrate}}
}
