% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{fetch_full_parameters}
\alias{fetch_full_parameters}
\title{Create Full Parameter Vector from Estimation Subset}
\usage{
fetch_full_parameters(pest, cfg)
}
\arguments{
\item{pest}{list containing subset of parameters being estimated}

\item{cfg}{ubiquity system object}
}
\value{
Full list of parameters with default values for the currently selected parameter set and the values in pest  merged
}
\description{
Can be used to take a subset of parameters (those being
estimated and returned from ' \code{\link{system_estimate_parameters}})
into a full list of system parameters.
}
\details{
This function is used to build a full parameter set from a subset, and is
 normally used during parameter estimation in the observation details
 function when the entire parameter vector is needed to simulate the system.

 The function select_set pulls out a parameter set and can optionally select
 only a subset for estimation:
\preformatted{pnames = c('Vp', 'CL')
cfg = system_select_set(cfg, "default", pnames)}

 The default values of this subset can be accessed in the following way:
\preformatted{pest = system_fetch_guess(cfg)}

 The estimation routines will work with this reduced parameter set, but to
 run simulations the full set is needed. The full values can be retrieved 
 using the following: 
\preformatted{parameters = fetch_full_parameters(pest, cfg) }
}
\seealso{
\code{\link{system_fetch_guess}}, \code{\link{system_select_set}}
}
\keyword{internal}
