% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_preprocessing.R
\name{rescale_predictions}
\alias{rescale_predictions}
\title{Rescale predictions to original scale.}
\usage{
rescale_predictions(scale_result, dt_predictions)
}
\arguments{
\item{scale_result}{A list object returned by \code{\link[=scale_data]{scale_data()}},
containing the means and standard deviations used for scaling.}

\item{dt_predictions}{A data frame containing the predictions,
including columns \code{prediction}, \code{prediction_lower}, \code{prediction_upper}.}
}
\value{
A data frame with the predictions and numeric columns rescaled back
to their original scale.
}
\description{
This function rescales the predicted values (\code{prediction}, \code{prediction_lower},
\code{prediction_upper}). The scaling is reversed using the means and
standard deviations that were saved from the training data. It is the inverse
function to \code{\link[=scale_data]{scale_data()}} and should be used only in combination.
}
\examples{
\donttest{
data(mock_env_data)
scale_res <- scale_data(
  train_data = mock_env_data[1:80, ],
  apply_data = mock_env_data[81:100, ]
)
params <- load_params()
res <- run_lightgbm(
  train = scale_res$train, test = scale_res$apply,
  params$lightgbm, alpha = 0.9, calc_shaps = FALSE
)
dt_predictions <- res$dt_predictions
rescaled_predictions <- rescale_predictions(scale_res, dt_predictions)
}
}
