% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_evaluation.R
\name{calc_summary_statistics}
\alias{calc_summary_statistics}
\title{Calculates summary statistics for predictions and true values}
\usage{
calc_summary_statistics(predictions, date_effect_start = NULL, buffer = 0)
}
\arguments{
\item{predictions}{Data.table or data.frame with the following columns
\describe{
\item{date}{Date of the observation. Needs to be comparable to
date_effect_start element.}
\item{value}{True observed value of the station}
\item{prediction}{Predicted model output for the same time and station
as value}
}}

\item{date_effect_start}{A date. Start date of the
effect that is to be evaluated. The data from this point onwards is disregarded
for calculating model performance}

\item{buffer}{Integer. An additional buffer window before date_effect_start to account
for uncertainty in the effect start point. Disregards additional buffer data
points for model evaluation}
}
\value{
data.frame of summary statistics with columns true and prediction
}
\description{
Helps with analyzing predictions by comparing them with the true values on
a number of relevant summary statistics.
}
