% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soloTB.R
\name{solo_upload}
\alias{solo_upload}
\title{upload mission file to solo}
\usage{
solo_upload(missionFile = NULL, connection = "udp:10.1.1.166:14550",
  prearm = "-9")
}
\arguments{
\item{missionFile}{mission file to upload}

\item{connection}{a valid connection string to the Solo default is "udp:10.1.1.166:14550"}

\item{prearm}{controls the prearm status of the Solo prearm check 0=Disabled,1=Enabled,-3=Skip Baro,-5=Skip Compass,-9=Skip GPS,-17=Skip INS,-33=Skip Params/Rangefinder,-65=Skip RC,127=Skip Voltage}
}
\description{
solo_upload provides a crude interface to upload the Solo mission file to the 3dr SOLO
}
\note{
for using the solo stuff you need to install: \cr sudo pip install pymavlink;\cr sudo pip install dronekit-sitl;\cr sudo pip install dronekit; \cr sudo apt-get install sshpass\cr Additionally you need to be connected to a running 3DR Solo uav
}
\examples{
wp <- system.file("extdata", "MAVLINK_waypoints.txt", package = "uavRmp")
solo_upload( missionFile = wp)

}
