% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morePlots.R
\name{condmomentPlot}
\alias{condmomentPlot}
\title{Condinional mean or variance plot for GMAR, StMAR, and G-StMAR models}
\usage{
condmomentPlot(gsmar, which_moment = c("mean", "variance"))
}
\arguments{
\item{gsmar}{object of class \code{'gsmar'} created with the function \code{fitGSMAR} or \code{GSMAR}.}

\item{which_moment}{should conditional means or variances be plotted?}
}
\value{
\code{condmomentPlot} only plots to a graphical device and does not return anything. Numerical values
 of the conditional means/variances can be extracted from the model with the dollar sign.
}
\description{
\code{condmomentPlot} plots the in-sample conditional means/variances of the model along with
 the time series contained in the model (e.g. the time series the model was fitted to). Also plots
 the regimiwise conditional means/variances multiplied with mixing weights - summing to the total conditional
 mean/veriance.
}
\details{
The conditional mean plot works best if the data contains positive values only.
}
\examples{
\donttest{
# GMAR model
fit12 <- fitGSMAR(simudata, p=1, M=2, model="GMAR")
condmomentPlot(fit12, which_moment="mean")
condmomentPlot(fit12, which_moment="variance")

# Restricted StMAR model: plot also the individual statistics with
# their approximate critical bounds using the given data
fit42r <- fitGSMAR(T10Y1Y, p=4, M=2, model="StMAR", restricted=TRUE)
condmomentPlot(fit42r, which_moment="mean")
condmomentPlot(fit42r, which_moment="variance")

# G-StMAR model with one GMAR type and one StMAR type regime
fit42g <- fitGSMAR(T10Y1Y, p=4, M=c(1, 1), model="G-StMAR")
condmomentPlot(fit42g, which_moment="mean")
condmomentPlot(fit42g, which_moment="variance")
}
}
\references{
\itemize{
   \item Galbraith, R., Galbraith, J. 1974. On the inverses of some patterned matrices arising
           in the theory of stationary time series. \emph{Journal of Applied Probability} \strong{11}, 63-71.
   \item Kalliovirta L. (2012) Misspecification tests based on quantile residuals.
           \emph{The Econometrics Journal}, \strong{15}, 358-393.
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2015. Gaussian Mixture Autoregressive model for univariate time series.
           \emph{Journal of Time Series Analysis}, \strong{36}, 247-266.
   \item Meitz M., Preve D., Saikkonen P. 2018. A mixture autoregressive model based on Student's t-distribution.
           arXiv:1805.04010 \strong{[econ.EM]}.
   \item Virolainen S. 2020. A mixture autoregressive model based on Gaussian and Student's t-distribution.	arXiv:2003.05221 [econ.EM].
 }
}
\seealso{
\code{\link{profile_logliks}}, \code{\link{diagnosticPlot}}, \code{\link{fitGSMAR}}, \code{\link{GSMAR}}, \code{\link{quantileResidualTests}},
 \code{\link{quantileResidualPlot}}
}
