% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootci_coeff_binary.R
\name{bootci_coeff_binary}
\alias{bootci_coeff_binary}
\title{Bootstrap samples to estimate confidence intervals for binary outcome coefficients.}
\usage{
bootci_coeff_binary(
  treatment,
  t.seq,
  m,
  outcome,
  span = 0.75,
  replicates = 1000
)
}
\arguments{
\item{treatment}{a vector indicating treatment group}

\item{t.seq}{a vector of unique time points for each observation}

\item{m}{matrix of mediator values in wide format}

\item{outcome}{matrix of outcome values in wide format}

\item{span}{Numeric value of the span to be used for LOESS regression. Default = 0.75.}

\item{replicates}{Number of replicates for bootstrapping confidence intervals. 
Default = 1000.}
}
\value{
\item{t.seq}{time points of estimation}

\item{CI.lower.a}{CI lower limit for alpha_hat}

\item{CI.upper.a}{CI upper limit for alpha_hat}

\item{CI.lower.g}{CI lower limit for gamma_hat}

\item{CI.upper.g}{CI upper limit for gamma_hat}

\item{CI.lower.b}{CI lower limit for beta_hat}

\item{CI.upper.b}{CI upper limit for beta_hat}

\item{CI.lower.t}{CI lower limit for tau_hat}

\item{CI.upper.t}{CI upper limit for tau_hat}
}
\description{
Internal function for estimating bootstrapped confidence intervals for the coefficients 
of the mediation model for a binary outcome.
}
