% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a_tuar1redf.R
\name{tuar1redf}
\alias{tuar1redf}
\title{Time-uncertain time-persistence AR(1) model}
\usage{
tuar1redf(y, ti.mu, ti.sd, n.sim, n.chains = 2, CV = FALSE, ...)
}
\arguments{
\item{y}{A vector of observations.}

\item{ti.mu}{A vector of estimates of timing of observations.}

\item{ti.sd}{A vector of standard deviations of timing.}

\item{n.sim}{A number of simulations.}

\item{n.chains}{A number of chains.}

\item{CV}{TRUE/FALSE cross-validation indicator.}

\item{...}{list of optional parameters:\cr
- n.chains: number of MCMC chains, the default number of chains is set to 2.\cr
- Thin: thinning factor, the default values is set to 4.\cr
- n.cores: number of cores used in cross-validation. No value or 'MAX' applies all the available cores in computation.\cr}
}
\description{
\code{tuar1redf} estimates parameters of the AR(1) model specified in
 \emph{"Climate Time Series Analysis"} by M.Mudelsee. We modify the model to account for time-uncertainty.\cr
}
\details{
Note: tuar1redf model estimates autocorrelation parameters with a certain bias unmitigated after
 the correction described in \emph{"Climate Time Series Analysis"} by M.Mudelsee.
 In addition the model is not suitable for time series series generated with negative values
 of autocorrelation parameters. In contrast, the function tuar1 generates unbiased estimates of the parameters,
 and is not limited to positive values of parameters.\cr
 We include this model to provide suppodt for justificaiton of results obtained with the REDFIT method.
}
\examples{
# Note: Most of models included in tuts package are computationally intensive. In the example
# below I set parameters to meet CRAN's testing requirement of maximum 5 sec per example.
# A more practical example would contain N=50 in the first line of the code and n.sim=10000.

#1. Import or simulate the data (a simulation is chosen for illustrative purposes):
DATA=simtuts(N=10,Harmonics=c(4,0,0), sin.ampl=c(10,0, 0), cos.ampl=c(0,0,0),
            trend=0,y.sd=2, ti.sd=0.2)
y=DATA$observed$y.obs
ti.mu=DATA$observed$ti.obs.tnorm
ti.sd= rep(0.2, length(ti.mu))

#2. Fit the model:
n.sim=1000
n.chains=2
AR1REDF=tuar1redf(y=y,ti.mu=ti.mu,ti.sd=ti.sd,n.sim=n.sim,n.chains=n.chains, CV=TRUE,n.cores=2)

#3. Generate summary results (optional parameters are listed in brackets):
summary(AR1REDF)                                # Summary results (CI, burn).

#4. Generate plots and diagnostics of the model (optional parameters are listed in brackets):
plot(AR1REDF,type='predTUTS',burn=0.2,CI=0.99)  # One step out of salmple predictions (CI, burn).
plot(AR1REDF,type='par', burn=0.4)              # Distributions of parameters (burn).
plot(AR1REDF,type='mcmc')                       # MCMC diagnostics.
plot(AR1REDF,type='cv', burn=0.4)               # 5 fold cross validation (CI, burn).
plot(AR1REDF,type='GR', burn=0.4)               # Gelman-Rubin diagnostic (CI, burn).
plot(AR1REDF,type='tau')                        # realizations of persistence of time.
}
