% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/b_tupoisBFS.R
\name{tupoisbsf}
\alias{tupoisbsf}
\title{Time uncertain Poisson regression with the Bayesian Frequency Selection method}
\usage{
tupoisbsf(y, ti.mu, ti.sd, n.sim, CV = FALSE, ...)
}
\arguments{
\item{y}{A vector of observations.}

\item{ti.mu}{A vector of estimates/observed timings of observations.}

\item{ti.sd}{A vector of standard deviations of timings.}

\item{n.sim}{A number of simulations.}

\item{CV}{TRUE/FALSE cross-validation indicator.}

\item{...}{optional arguments: \cr
- n.chains: number of MCMC chains, the default number of chains is set to 2.\cr
- Thin: thinning factor, the default values is set to 4.\cr
- m: maximum number of significant frequencies in the data, the default value is set to 5. \cr
- polyorder: the polynomial regression component, the default odrer is set to 3. \cr
- freqs: set to a positive integer k returns a vector of k equally spaced frequencies in the Nyquist
  range. freqs can be provided as a vector of custom frequencies of interest. Set to 'internal'
  (the default value) generates a vector of equally spaced frequencies in the Nyquist range.
- n.cores: number of cores used in cross-validation. No value or 'MAX' applies all the available cores in computation.\cr}
}
\description{
\code{tupoisbsf} performs spectral analysis of time-uncertain time series of count data
using bayesian frequency selection method.
}
\examples{
# Note: Most of models included in tuts package are computationally intensive. In the example
# below I set parameters to meet CRAN’s testing requirement of maximum 5 sec per example.
# A more practical example would contain N=50 in the first line of the code and n.sim=10000.

#1. Import or simulate the data (simulation is chosen for illustrative purposes):
DATA=simtuts(N=7,Harmonics=c(4,0,0), sin.ampl=c(10,0, 0), cos.ampl=c(0,0,0),
            trend=0,y.sd=2, ti.sd=0.2)
y=DATA$observed$y.obs
y=round(y-min(y))
ti.mu=DATA$observed$ti.obs.tnorm
ti.sd= rep(0.2, length(ti.mu))

#2. Fit the model:
n.sim=10
TUPOIS=tupoisbsf(y=y,ti.mu=ti.mu,ti.sd=ti.sd,freqs='internal',n.sim=n.sim,n.chains=2,
                 CV=TRUE,n.cores=2)

#3. Generate summary results (optional parameters are listed in brackets):
summary(TUPOIS)                               # Summary results (CI, burn).
summary(TUPOIS,burn=0.2)                      # Results after 20\% of burn-in (CI).

#4. Generate plots and diagnostics of the model (optional parameters are listed in brackets):
plot(TUPOIS,type='periodogram')               # spectral analysis (CI, burn).
plot(TUPOIS,type='predTUTS', CI=0.99)         # One step predictions (CI, burn).
plot(TUPOIS,type='cv')                        # 5 fold cross validation (CI, burn).
plot(TUPOIS,type='GR')                        # Gelman-Rubin diagnostics (CI, burn).
plot(TUPOIS,type='mcmc')                      # MCMC diagnostics.
plot(TUPOIS,type='lambda')                    # Realizaitons of lambda.
}
