% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_captions.R
\name{get_captions}
\alias{get_captions}
\title{Get Captions of a Video}
\usage{
get_captions(video_id = NULL, lang = "en", id = NULL, ...)
}
\arguments{
\item{video_id}{ID of the video whose captions are requested. Required. No default.}

\item{lang}{Language of the caption; required; default is \code{"en"} (English)}

\item{id}{String. id of the caption track that is being retrieved}

\item{\dots}{Additional arguments passed to \code{\link{tuber_GET}}.}
}
\value{
String.
}
\description{
A few of Youtube videos have caption tracks available from an older 
YouTube API. If that caption track is available, this function returns that,
Or it returns caption track specified by id resource. Check \code{\link{list_caption_tracks}} for more
information.
}
\examples{
\dontrun{

# Set API token via yt_oauth() first

get_captions(video_id="yJXTXN4xrI8")
get_captions(id="y3ElXcEME3lSISz6izkWVT5GvxjPu8pA")
}
}

