% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto_data_cleaning.R
\name{auto_data_cleaning}
\alias{auto_data_cleaning}
\title{Perform automatic data cleaning of time series data}
\usage{
auto_data_cleaning(data, tau = 0.5, S, extreg = NULL, ...)
}
\arguments{
\item{data}{an input vector, matrix or data frame of dimension nobs x nvars
containing missing values; each column is a variable.}

\item{tau}{the quantile(s) of the missing values to be estimated in the
quantile regression. Tau accepts all values in (0,1), the default is 0.5.}

\item{S}{a number of observations per period, e.g. per day.}

\item{extreg}{a vector, matrix or data frame of data containing external
regressors.}

\item{...}{additional arguments for the \link[tsrobprep]{model_missing_data}
and \link[tsrobprep]{handle_outliers} functions.}
}
\value{
A matrix or a list of matrices with imputed missing values or
outliers.
}
\description{
Returns a matrix or a list of matrices with imputed missing values and
outliers. The function automatizes the usage of functions
\link[tsrobprep]{model_missing_data}, \link[tsrobprep]{handle_outliers} and
\link[tsrobprep]{impute_modelled_data}. The function is designed for numerical
data only.
}
\details{
The function calls \link[tsrobprep]{model_missing_data} and
\link[tsrobprep]{handle_outliers} functions simultaneously and combines the
results. For details see the functions' respective help sections.
}
\examples{
autoclean <- auto_data_cleaning(data = GBload[,-1], S = 48, tau = 0.5,
             no.of.last.indices.to.fix = dim(GBload)[1], consider.as.missing = 0,
             min.val = 0)
}
\seealso{
\link[tsrobprep]{model_missing_data}, \link[tsrobprep]{handle_outliers},
\link[tsrobprep]{impute_modelled_data}
}
