#' Computes statistics from a vector of of values.
#'
#' E.g. computes features from distribution of distance.
#' Computed statistics: min, median, mean, max, sd, span, coeff_of_var.
#'
#' @param x [\code{numeric}]\cr
#'   Numeric vector.
#' @param name [\code{numeric}]\cr
#'   Prefix name for elements in result list.
#' @param na.rm [\code{logical(1)}]\cr
#'   Should NAs in \code{x} be removed?
#'   Default is \code{TRUE}.
#' @return [\code{list}]
#'   Elements are named <name_statistic>.
#' @export   
numvec_feature_statistics = function(x, name, na.rm = TRUE) {
	xmin  = min(x, na.rm = na.rm)
	xmax  = max(x, na.rm = na.rm)
  xmean = mean(x, na.rm = na.rm)
  xsd   = sd(as.numeric(x), na.rm = na.rm)
	f = list(
		min = xmin,
		median = median(x, na.rm = na.rm),
		mean = xmean,
		max = xmax,
		sd = xsd,
		span = xmax - xmin,
    coef_of_var = xsd / xmean
	)
	setNames(f, paste(name, names(f), sep="_"))
}