% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mass_weighted.R
\name{mass_weighted}
\alias{mass_weighted}
\title{Calculates the distance profile using MASS_WEIGHTED algorithm}
\usage{
mass_weighted(
  query_window,
  window_size,
  data_fft,
  data_size,
  data_mean,
  data_sd,
  data_pre,
  weight,
  ...
)
}
\arguments{
\item{query_window}{a \code{vector} of \code{numeric}. Query window.}

\item{window_size}{an \code{int}. Sliding window size.}

\item{data_fft}{precomputed data product.}

\item{data_size}{an \code{int}. The length of the reference data.}

\item{data_mean}{precomputed data moving average.}

\item{data_sd}{precomputed data moving standard deviation.}

\item{data_pre}{precomputed weighted data product.}

\item{weight}{a \code{vector} of \code{numeric} with the same length of the \code{window_size}.}

\item{\dots}{just a placeholder to catch unused parameters.}
}
\value{
Returns the \code{distance_profile} for the given query and the \code{last_product} for STOMP
algorithm.
}
\description{
Mueen's Algorithm for Similarity Search is The Fastest Similarity Search Algorithm for Time
Series Subsequences under Euclidean Distance and Correlation Coefficient.
}
\examples{
w <- mp_toy_data$sub_len
ref_data <- mp_toy_data$data[, 1]
query_data <- mp_toy_data$data[, 1]
weight <- c(
  rep(1, mp_toy_data$sub_len / 3), rep(0.5, mp_toy_data$sub_len / 3),
  rep(1, mp_toy_data$sub_len / 3)
)

pre <- tsmp:::mass_pre_w(ref_data, query_data, w, weight)

dp <- list()
for (i in 1:(pre$data_size - w + 1)) {
  dp[[i]] <- tsmp:::mass_weighted(
    query_data[i:(i - 1 + w)], pre$window_size, pre$data_fft, pre$data_size,
    pre$data_mean, pre$data_sd, pre$data_pre, pre$weight
  )
}
}
\references{
\itemize{
\item Abdullah Mueen, Yan Zhu, Michael Yeh, Kaveh Kamgar, Krishnamurthy Viswanathan,
Chetan Kumar Gupta and Eamonn Keogh (2015), The Fastest Similarity Search Algorithm for Time
Series Subsequences under Euclidean Distance
}

Website: \url{https://www.cs.unm.edu/~mueen/FastestSimilaritySearch.html}
}
\seealso{
\code{\link[=mass_pre_w]{mass_pre_w()}} to precomputation of input values.
}
\keyword{internal}
